<?php
/**
 * Custom icons for the Prespa theme.
 *
 * @package Prespa
 * @link https://feathericons.com/
 * @since prespa 0.0.0
 */

function prespa_get_svg( $icon ) {

	$svg_icons = array(
		'archive'         => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-archive"><polyline points="21 8 21 21 3 21 3 8"></polyline><rect x="1" y="3" width="22" height="5"></rect><line x1="10" y1="12" x2="14" y2="12"></line></svg>',
		'arrow-double-up' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" role="img" fill="none" stroke="#000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevrons-up"><polyline points="17 11 12 6 7 11"></polyline><polyline points="17 18 12 13 7 18"></polyline></svg>',
		'behance'         => '<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" class="anast" fill="none" stroke="currentColor" stroke-width="2"><path d="M1 6h6a3 3 0 0 1 3 3h0a3 3 0 0 1-3 3H1"/><path d="M1 12h7.5a3.5 3.5 0 0 1 3.5 3.5h0A3.5 3.5 0 0 1 8.5 19H1"/><g stroke-linecap="round"><path d="M22.625 16.301A4.5 4.5 0 0 1 14 14.5a4.5 4.5 0 0 1 8.973-.5"/><path d="M23 14h-9M1 6v13"/><path d="M16 7h5"/></g></svg>',
		'calendar'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>',
		'clock'           => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-clock"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>',
		'comment'         => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-message-square"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>',
		'close'           => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>',
		'dribble'         => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-dribbble"><circle cx="12" cy="12" r="10"></circle><path d="M8.56 2.75c4.37 6.03 6.02 9.42 8.03 17.72m2.54-15.38c-3.72 4.35-8.94 5.66-16.88 5.85m19.5 1.9c-3.5-.93-6.63-.82-8.94 0-2.58.92-5.01 2.86-7.44 6.32"></path></svg>',
		'eye'             => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>',
		'facebook'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" class="feather feather-facebook" role="img" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-facebook"><path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path></svg>',
		'fallback-svg'    => '<svg xmlns="http://www.w3.org/2000/svg" width="100%" fill="#cdcdcd" class="fallback-svg" viewBox="0 0 512 384"><path d="M231.941 169.348a15.65 15.65 0 0 1-4.583 11.065c-2.934 2.934-6.913 4.582-11.063 4.582s-8.13-1.649-11.063-4.582a15.65 15.65 0 0 1-4.582-11.065c0-4.15 1.648-8.129 4.582-11.063a15.65 15.65 0 0 1 26.71 11.063zm-41.724-46.935c-5.532 0-10.839 2.198-14.752 6.11s-6.109 9.219-6.109 14.751v104.308a20.86 20.86 0 0 0 6.109 14.751 20.87 20.87 0 0 0 14.752 6.111h125.17a20.86 20.86 0 0 0 20.862-20.862V143.274a20.86 20.86 0 0 0-20.862-20.861zm125.17 10.431a10.43 10.43 0 0 1 10.431 10.431v67.799l-39.397-20.308a5.21 5.21 0 0 0-6.019.97l-38.698 38.699-27.747-18.484a5.22 5.22 0 0 0-6.571.646l-27.599 24.554v-93.877a10.43 10.43 0 0 1 3.054-7.376c1.957-1.956 4.61-3.055 7.376-3.055z"/></svg>',
		'flickr'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" class="anast" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="11"/><circle cx="7.5" cy="11.5" r="3.5"/><circle cx="16.5" cy="11.5" r="3.5"/></svg>',
		'folder'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-folder"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"></path></svg>',
		'globe'           => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-globe"><circle cx="12" cy="12" r="10"></circle><line x1="2" y1="12" x2="22" y2="12"></line><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path></svg>',
		'heart'           => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" role="img" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-heart"><path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"></path></svg>',
		'home'            => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-home"><path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline></svg>',
		'github'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-github"><path d="M9 19c-5 1.5-5-2.5-7-3m14 6v-3.87a3.37 3.37 0 0 0-.94-2.61c3.14-.35 6.44-1.54 6.44-7A5.44 5.44 0 0 0 20 4.77 5.07 5.07 0 0 0 19.91 1S18.73.65 16 2.48a13.38 13.38 0 0 0-7 0C6.27.65 5.09 1 5.09 1A5.07 5.07 0 0 0 5 4.77a5.44 5.44 0 0 0-1.5 3.78c0 5.42 3.3 6.61 6.44 7A3.37 3.37 0 0 0 9 18.13V22"></path></svg>',
		'instagram'       => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-instagram"><rect x="2" y="2" width="20" height="20" rx="5" ry="5"></rect><path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path><line x1="17.5" y1="6.5" x2="17.51" y2="6.5"></line></svg>',
		'linkedin'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-linkedin"><path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z"></path><rect x="2" y="9" width="4" height="12"></rect><circle cx="4" cy="4" r="2"></circle></svg>',
		'map-pin'         => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-map-pin"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>',
		'mail'            => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" role="img" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-mail"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>',
		'moon'            => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-moon"><path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z"></path></svg>',
		'phone'           => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" role="img" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-phone"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>',
		'pinterest'       => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" class="anast" fill="none" stroke="currentColor" stroke-width="2"><path d="M8.628 21l2.377-9.122c.205-.787.147-2.018-.641-1.818-.548.139-1.055.933-.796 2.499.49 2.964 2.546 4.875 5.695 3.971 3.504-1.007 3.942-7.755-.438-9.83-4.519-2.141-8.323 1.007-8.761 4.412-.357 2.772.876 4.095 1.752 4.412" stroke-linecap="round"/><circle cx="12" cy="12" r="10"/></svg>',
		'search'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
		'shopping-cart'   => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-cart"><circle cx="9" cy="21" r="1"></circle><circle cx="20" cy="21" r="1"></circle><path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path></svg>',
		'snapchat'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" class="anast" fill="none" stroke="currentColor" stroke-width="2" stroke-linejoin="round"><path d="M12 2c6.5 0 6 7.875 6 7.875.833-.175 4-.525 3.5 1.05-.222.7-1.394.574-2.5 1.575-.675.612-1 1.575-1 2.1 0 1.575 2 3.78 4 4.2-.833.175-1.501 1.401-2.5 2.1-.909.636-2-.525-3.5.08-1.103.445-2 2.02-4.5 2.02M12 2C5 2 6 9.875 6 9.875c-.833-.175-4-.525-3.5 1.05.222.7 1.394.574 2.5 1.575.675.612 1 1.575 1 2.1 0 1.575-2 3.78-4 4.2.833.175 1.502 1.401 2.5 2.1.909.636 2-.525 3.5.08 1.103.445 1.5 2.02 3.5 2.02"/></svg>',
		'soundcloud'      => '<svg xmlns="http://www.w3.org/2000/svg" width="34" height="24" class="anast" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"><path d="M1 12v9M4 9v12M7 6v15m3-13v13m3-.5h14.359c2.564 0 5.641-1.292 5.641-4.643 0-4.189-4.103-6.051-7.692-5.12-.513-2.793-1.538-4.688-3.59-6.051S16.109 3.118 13 4.161"/></svg>',
		'sun'             => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-sun"><circle cx="12" cy="12" r="5"></circle><line x1="12" y1="1" x2="12" y2="3"></line><line x1="12" y1="21" x2="12" y2="23"></line><line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line><line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line><line x1="1" y1="12" x2="3" y2="12"></line><line x1="21" y1="12" x2="23" y2="12"></line><line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line><line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line></svg>',
		'tag'             => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-tag"><path d="M20.59 13.41l-7.17 7.17a2 2 0 0 1-2.83 0L2 12V2h10l8.59 8.59a2 2 0 0 1 0 2.82z"></path><line x1="7" y1="7" x2="7.01" y2="7"></line></svg>',
		'telegram'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11.985 15.408l3.241 3.685c1.201 1.365 1.801 2.048 2.43 1.882s.844-1.065 1.275-2.862l2.391-9.968c.664-2.768.996-4.151.258-4.834s-2.017-.175-4.575.841L5.139 8.864c-2.046.812-3.069 1.218-3.134 1.916-.007.071-.007.143 0 .215.063.698 1.084 1.108 3.128 1.927.926.371 1.389.557 1.721.912l.108.124c.306.38.436.879.697 1.876l.488 1.867c.254.971.381 1.456.714 1.522s.622-.336 1.201-1.141l1.924-2.674zm0 0l-.318-.331c-.362-.377-.543-.565-.543-.8s.181-.423.543-.8l3.573-3.724" stroke-width="1.5"/></svg>',
		'tiktok'          => '<svg xmlns="http://www.w3.org/2000/svg" width="22" height="24" class="anast" fill="none" stroke="currentColor" stroke-width="2"><path d="M6.949 10.821C3.664 10.821 1 13.548 1 16.911S3.664 23 6.949 23s5.95-2.726 5.95-6.089V1c.576 1.899.96 6.286 7.101 7.268"/></svg>',
		'tumblr'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" class="anast" fill="none" stroke="currentColor" stroke-width="2"><path d="M16.648 6.5l.113 3.857h-3.485-.5v.5 5.714c0 1.758 2.079 2.688 3.39 1.517l.34-.304 1.539 2.693-.422.534c-.397.463-.989 1.054-1.767 1.572-.751.501-1.537.731-2.141.836-.301.052-.553.072-.727.079l-.198.003-.048-.001h-.01 0 0 0 0 0l-.013-.001h-.014a4.07 4.07 0 0 1-4.071-4.071v-8.571-.5h-.5H5.5V6.485c.98-.059 1.783-.293 2.435-.668.762-.437 1.287-1.048 1.645-1.727.606-1.149.737-2.506.762-3.59h2.434V6v.5h.5 3.372z"/></svg>',
		'twitch'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-twitch"><path d="M21 2H3v16h5v4l4-4h5l4-4V2zm-10 9V7m5 4V7"></path></svg>',
		'twitter'         => '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M11 12.5L2.5 1.5H8L14.5 10.3833M11 12.5L18 22H23L14.5 10.3833M11 12.5L1.5 23M14.5 10.3833L22.5 1"/></svg>',
		'user'            => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>',
		'wordpress'       => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" class="anast wp" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><g stroke-linecap="round"><path d="M4 8l5.211 12L13 12.5m-1.5-4l4.5 11c1.468-3.089 3.716-9.668 3.212-11.786-.674-2.836-4.589-2.73-1.966 0 .874.91 1.672 2.275 1.532 3.64"/><path d="M4 8h3m3 0h4"/></g></svg>',
		'youtube'         => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-youtube"><path d="M22.54 6.42a2.78 2.78 0 0 0-1.94-2C18.88 4 12 4 12 4s-6.88 0-8.6.46a2.78 2.78 0 0 0-1.94 2A29 29 0 0 0 1 11.75a29 29 0 0 0 .46 5.33A2.78 2.78 0 0 0 3.4 19c1.72.46 8.6.46 8.6.46s6.88 0 8.6-.46a2.78 2.78 0 0 0 1.94-2 29 29 0 0 0 .46-5.25 29 29 0 0 0-.46-5.33z"></path><polygon points="9.75 15.02 15.5 11.75 9.75 8.48 9.75 15.02"></polygon></svg>',
	);

	if ( array_key_exists( $icon, $svg_icons ) ) {
		$svg = trim( $svg_icons[ $icon ] ); // Add extra attributes to SVG code.
		$svg = preg_replace( "/([\n\t]+)/", ' ', $svg ); // Remove newlines & tabs.
		$svg = preg_replace( '/>\s*</', '><', $svg );    // Remove whitespace between SVG tags.
		return $svg;
	}
	return null;

}
